/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.ArmorStandUtils;
import it.jakegblp.lusk.utils.Constants;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - has Base Plate (Property)")
@Description(value={"Gets and sets the `hasBasePlate` property of an armorstand entity or item, to do so with an armorstand item you must be using Paper.\n"})
@Examples(value={"set has base plate property of target to true", "set has base plate state of target to false"})
@Since(value={"1.0.2, 1.3 (Item)"})
public class ExprArmorStandHasBasePlate
extends SimpleBooleanPropertyExpression<Object> {
    @Override
    public boolean setNegated(int matchedPattern, SkriptParser.ParseResult parseResult) {
        return parseResult.hasTag("in");
    }

    @Override
    public void set(Object from, Boolean to) {
        ArmorStandUtils.setHasBasePlate(from, to);
    }

    @Override
    public void reset(Object from) {
        ArmorStandUtils.setHasBasePlate(from, true);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(Object from) {
        return ArmorStandUtils.hasBasePlate(from) ^ this.isNegated();
    }

    protected String getPropertyName() {
        return "armor stand base plate " + (this.isNegated() ? "in" : "") + "visibility property";
    }

    static {
        ExprArmorStandHasBasePlate.register(ExprArmorStandHasBasePlate.class, Boolean.class, "[armor[ |-]stand]", "((have|has|show[s]) [its|their] base plate|[have|has] base plate [:in]visibility)", Constants.ARMOR_STAND_TYPES);
    }
}

