/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.armorstand.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.enums.BodyPart;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.VectorUtils;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Armor Stand - Rotations")
@Description(value={"The rotation of each part of an armor stand.\nCan be set, added to, removed from, and reset.\nAll change modes allow both a vector and an euler angle."})
@Examples(value={"broadcast rotation of target", "set head rotation of target to vector(45,0,0)\n# looks down a a 45 degrees - sad armor stand :("})
@Since(value={"1.0.2, 1.3 (Degrees)"})
public class ExprArmorStandRotations
extends PropertyExpression<LivingEntity, Vector> {
    private Expression<BodyPart> bodyPartExpression;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.bodyPartExpression = expressions[0];
            this.setExpr(expressions[1]);
        } else {
            this.setExpr(expressions[0]);
            this.bodyPartExpression = expressions[1];
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return super.isSingle() && this.bodyPartExpression.isSingle();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[2];
                classArray2[0] = Vector.class;
                classArray = classArray2;
                classArray2[1] = EulerAngle.class;
                break;
            }
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            default: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Stream<ArmorStand> armorStands = this.getExpr().stream(event).filter(ArmorStand.class::isInstance).map(ArmorStand.class::cast);
        if (mode == Changer.ChangeMode.RESET) {
            armorStands.forEach(armorStand -> this.bodyPartExpression.stream(event).forEach(bodyPart -> bodyPart.set((ArmorStand)armorStand, null)));
        } else {
            Vector vector;
            Object object = delta[0];
            if (object instanceof Vector) {
                Vector v;
                vector = v = (Vector)object;
            } else {
                object = delta[0];
                if (object instanceof EulerAngle) {
                    EulerAngle eulerAngle = (EulerAngle)object;
                    vector = VectorUtils.toVector(eulerAngle);
                } else {
                    vector = null;
                }
            }
            if (vector != null) {
                armorStands.forEach(armorStand -> this.bodyPartExpression.stream(event).forEach(bodyPart -> bodyPart.set((ArmorStand)armorStand, switch (mode) {
                    case Changer.ChangeMode.SET -> vector;
                    case Changer.ChangeMode.ADD -> bodyPart.get((ArmorStand)armorStand).add(vector);
                    case Changer.ChangeMode.REMOVE -> bodyPart.get((ArmorStand)armorStand).subtract(vector);
                    default -> null;
                })));
            }
        }
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    protected Vector[] get(Event event, LivingEntity[] source) {
        return (Vector[])Arrays.stream(source).filter(ArmorStand.class::isInstance).map(ArmorStand.class::cast).flatMap(armorStand -> this.bodyPartExpression.stream(event).map(bodyPart -> bodyPart.get((ArmorStand)armorStand))).toArray(Vector[]::new);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "the armor stand " + this.bodyPartExpression.toString(event, debug) + " rotations of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprArmorStandRotations.register(ExprArmorStandRotations.class, Vector.class, "[armor[ |-]stand] %bodyparts% (rotation|pose)[s]", "livingentities");
    }
}

