/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.bucketable.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import io.papermc.paper.entity.Bucketable;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;

@Name(value="Bucketable - is From a Bucket")
@Description(value={"Checks whether a living entity was previously in a bucket."})
@Examples(value={"if {_fish} is from a bucket:"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"Paper 1.18+"})
public class CondBucketableIsFromBucket
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity livingEntity) {
        Bucketable bucketable;
        return livingEntity instanceof Bucketable && (bucketable = (Bucketable)livingEntity).isFromBucket();
    }

    protected String getPropertyName() {
        return "from a bucket";
    }

    static {
        if (Constants.PAPER_1_18) {
            CondBucketableIsFromBucket.register(CondBucketableIsFromBucket.class, (String)"from [a] bucket", (String)"livingentities");
        }
    }
}

