/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.bucketable.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import io.papermc.paper.entity.Bucketable;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Bucketable - Base Bucket Item")
@Description(value={"Gets the base item of this entity in a bucket form."})
@Examples(value={"set {_bucket} to base bucket item of {_fish}"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"Paper 1.18+"})
public class ExprBucketableBaseBucketItem
extends SimplerPropertyExpression<LivingEntity, ItemType> {
    @Nullable
    public ItemType convert(LivingEntity from) {
        ItemType itemType;
        if (from instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)from;
            itemType = new ItemType(bucketable.getBaseBucketItem());
        } else {
            itemType = null;
        }
        return itemType;
    }

    protected String getPropertyName() {
        return "base bucket item";
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    static {
        if (Constants.PAPER_1_18) {
            ExprBucketableBaseBucketItem.register(ExprBucketableBaseBucketItem.class, ItemType.class, (String)"base bucket item", (String)"livingentities");
        }
    }
}

