/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.cat.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Cat;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Cat - is Looking Up")
@Description(value={"Checks if a cat is looking up"})
@Examples(value={"on damage:\n\tif victim is looking up:\n\t\tbroadcast \"it's looking up!\""})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper 1.18.2+"})
public class CondCatIsLookingUp
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Cat cat;
        return entity instanceof Cat && (cat = (Cat)entity).isHeadUp();
    }

    @NotNull
    protected String getPropertyName() {
        return "looking up";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            CondCatIsLookingUp.register(CondCatIsLookingUp.class, (String)"looking up", (String)"livingentities");
        }
    }
}

