/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.chicken.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.LivingEntity;

@Name(value="Chicken - is Chicken Jockey")
@Description(value={"Checks if the provided chickens are chicken jockeys."})
@Examples(value={"if {_chicken} is chicken jockey:"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper"})
public class CondChickenJockey
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity value) {
        Chicken chicken;
        return value instanceof Chicken && (chicken = (Chicken)value).isChickenJockey();
    }

    protected String getPropertyName() {
        return "chicken jockey";
    }

    static {
        if (Constants.PAPER_1_19_2) {
            CondChickenJockey.register(CondChickenJockey.class, (String)"[a] chicken jockey", (String)"livingentities");
        }
    }
}

