/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.chicken.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Chicken - Egg Lay Time/Ticks")
@Description(value={"Returns the time till a chicken lays an egg."})
@Examples(value={"set egg lay time of target to 2 minutes"})
@Since(value={"1.0.3, 1.3 (Ticks)"})
@RequiredPlugins(value={"Paper"})
public class ExprChickenEggLayTime
extends SimplePropertyExpression<LivingEntity, Object> {
    private boolean usesTicks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.usesTicks = parseResult.hasTag("ticks");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Object convert(LivingEntity from) {
        if (from instanceof Chicken) {
            Chicken chicken = (Chicken)from;
            int ticks = chicken.getEggLayTime();
            if (this.usesTicks) {
                return ticks;
            }
            return CompatibilityUtils.fromTicks(ticks);
        }
        return null;
    }

    protected String getPropertyName() {
        return "chicken egg lay " + (this.usesTicks ? "ticks" : "time");
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Timespan.class;
            classArray = classArray2;
            classArray2[1] = Integer.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && delta != null) {
            Integer ticks;
            Object object = delta[0];
            if (object instanceof Timespan) {
                Timespan timespan = (Timespan)object;
                ticks = (int)CompatibilityUtils.getTicks(timespan);
            } else {
                Integer integer;
                object = delta[0];
                ticks = object instanceof Integer ? (integer = (Integer)object) : null;
            }
            if (ticks != null) {
                this.getExpr().stream(event).forEach(livingEntity -> {
                    if (livingEntity instanceof Chicken) {
                        Chicken chicken = (Chicken)livingEntity;
                        chicken.setEggLayTime(ticks.intValue());
                    }
                });
            }
        }
    }

    static {
        if (Constants.PAPER_1_19_2) {
            ExprChickenEggLayTime.register(ExprChickenEggLayTime.class, Object.class, (String)"[chicken] egg lay (time|:ticks)", (String)"livingentities");
        }
    }
}

