/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.creeper.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import it.jakegblp.lusk.utils.LuskUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtCreeperIgnite
extends SkriptEvent {
    private Kleenean ignite;

    public boolean init(Literal @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        this.ignite = LuskUtils.getKleenean(matchedPattern == 0, matchedPattern == 1);
        return true;
    }

    public boolean check(@NotNull Event e) {
        return switch (this.ignite) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.UNKNOWN -> false;
            case Kleenean.FALSE -> {
                if (!((CreeperIgniteEvent)e).isIgnited()) {
                    yield true;
                }
                yield false;
            }
            case Kleenean.TRUE -> ((CreeperIgniteEvent)e).isIgnited();
        };
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "creeper " + (switch (this.ignite) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.UNKNOWN -> "ignite toggle";
            case Kleenean.FALSE -> "extinguish";
            case Kleenean.TRUE -> "ignite";
        });
    }

    static {
        if (Skript.classExists((String)"com.destroystokyo.paper.event.entity.CreeperIgniteEvent")) {
            Skript.registerEvent((String)"Creeper - on Ignite/Extinguish", EvtCreeperIgnite.class, CreeperIgniteEvent.class, (String[])new String[]{"creeper ignit(e[d]|ion|ing)", "creeper extinguish[ed|ing]", "creeper ignite toggle[d]"}).description(new String[]{"Called when a Creeper is ignited."}).examples(new String[]{"on creeper ignite:\n\tbroadcast \"%entity% is about to explode!\""}).since("1.0.2+").requiredPlugins(new String[]{"Paper"});
        }
    }
}

