/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.dolphin.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Location;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Dolphin - Treasure Chest Location")
@Description(value={"Gets the treasure location the provided dolphins try to guide players to.\n\nThis value is calculated if the player has fed the dolphin a fish (which Lusk includes), `DOLPHIN_SWIM_TO_TREASURE` goal.\n\nCan be set, but it only has an effect if the dolphin is currently leading a player, as this value is recalculated next time it leads a player.\n\nThe world of the location you give it does not matter, as the dolphin will always use the world it is currently in.\n"})
@Examples(value={"broadcast dolphin treasure location of target"})
@Since(value={"1.0.3"})
@RequiredPlugins(value={"Paper"})
public class ExprDolphinTreasure
extends SimplerPropertyExpression<LivingEntity, Location> {
    @Nullable
    public Location convert(LivingEntity from) {
        Location location;
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            location = dolphin.getTreasureLocation();
        } else {
            location = null;
        }
        return location;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Location to) {
        if (from instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)from;
            dolphin.setTreasureLocation(to);
        }
    }

    protected String getPropertyName() {
        return "dolphin treasure location";
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprDolphinTreasure.register(ExprDolphinTreasure.class, Location.class, (String)"dolphin treasure [chest] location", (String)"livingentities");
        }
    }
}

