/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endercrystal.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="End Crystal - Hide/Show Bottom Plate")
@Description(value={"Hides or shows the bedrock slate underneath the provided end crystals."})
@Examples(value={"show {_crystal}'s bottom plate"})
@Since(value={"1.3"})
public class EffEndCrystalBottom
extends Effect {
    private boolean show;
    private Expression<Entity> entityExpression;

    protected void execute(Event event) {
        for (Entity entity : (Entity[])this.entityExpression.getAll(event)) {
            if (!(entity instanceof EnderCrystal)) continue;
            EnderCrystal enderCrystal = (EnderCrystal)entity;
            enderCrystal.setShowingBottom(this.show);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return (this.show ? "show" : "hide") + " end crystal bedrock plate of " + this.entityExpression.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = expressions[0];
        this.show = parseResult.hasTag("show");
        return true;
    }

    static {
        Skript.registerEffect(EffEndCrystalBottom.class, (String[])new String[]{"(hide|:show) end[er] crystal (bottom|bedrock) [plate|slate] of %entities%", "(hide|:show) %entities%'[s] end[er] crystal (bottom|bedrock) [plate|slate]"});
    }
}

