/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endercrystal.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.Location;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="End Crystal - Beam Target")
@Description(value={"Gets the location that the provided end crystals are pointing their beam to.\nCan be set, if the provided location is in a different world it will fail silently."})
@Examples(value={"set end crystal beam target to {_location}"})
@Since(value={"1.3"})
public class ExprEndCrystalBeamTarget
extends SimplerPropertyExpression<Entity, Location> {
    @Nullable
    public Location convert(Entity from) {
        Location location;
        if (from instanceof EnderCrystal) {
            EnderCrystal enderCrystal = (EnderCrystal)from;
            location = enderCrystal.getBeamTarget();
        } else {
            location = null;
        }
        return location;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Entity from, @Nullable Location to) {
        if (to != null && from.getWorld() != to.getWorld()) {
            return;
        }
        if (from instanceof EnderCrystal) {
            EnderCrystal enderCrystal = (EnderCrystal)from;
            enderCrystal.setBeamTarget(to);
        }
    }

    @Override
    public void delete(Entity from) {
        this.set(from, null);
    }

    protected String getPropertyName() {
        return "ender crystal beam target";
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    static {
        ExprEndCrystalBeamTarget.register(ExprEndCrystalBeamTarget.class, Location.class, (String)"[end[er] crystal] beam target [location]", (String)"entities");
    }
}

