/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endercrystal.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="End Crystal - is Showing Bottom (Property)")
@Description(value={"Returns whether or not the provided end crystals are showing the bedrock slate underneath them.\nCan be set."})
@Examples(value={"set the is showing bottom plate property of {_crystal} to false"})
@Since(value={"1.3"})
public class ExprEndCrystalShowingBottom
extends SimpleBooleanPropertyExpression<Entity> {
    @Override
    public void set(Entity from, Boolean to) {
        if (from instanceof EnderCrystal) {
            EnderCrystal enderCrystal = (EnderCrystal)from;
            enderCrystal.setShowingBottom(to.booleanValue());
        }
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Nullable
    public Boolean convert(Entity from) {
        EnderCrystal enderCrystal;
        return from instanceof EnderCrystal && (enderCrystal = (EnderCrystal)from).isShowingBottom();
    }

    protected String getPropertyName() {
        return "";
    }

    static {
        ExprEndCrystalShowingBottom.register(ExprEndCrystalShowingBottom.class, Boolean.class, "[end[er] crystal]", "[is] showing [the] (bottom|bedrock) [plate|slate]", "entities");
    }
}

