/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderman.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enderman - Teleport Towards Entity")
@Description(value={"Attempts to teleport an enderman to a random nearby location.\nRequires Spigot 1.20.1+."})
@Examples(value={"teleport {_endermen::*} towards {_entity}"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.20.1"})
public class EffEndermanTeleportTowards
extends Effect {
    private Expression<LivingEntity> endermanExpression;
    private Expression<LivingEntity> entityExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.endermanExpression = expressions[0];
        this.entityExpression = expressions[1];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "teleport " + this.endermanExpression.toString(event, debug) + " towards " + this.entityExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        LivingEntity entity = (LivingEntity)this.entityExpression.getSingle(event);
        if (entity == null) {
            return;
        }
        for (LivingEntity livingEntity : (LivingEntity[])this.endermanExpression.getArray(event)) {
            if (!(entity instanceof Enderman)) continue;
            Enderman enderman = (Enderman)entity;
            enderman.teleportTowards((Entity)livingEntity);
        }
    }

    static {
        if (Constants.MINECRAFT_1_20_1) {
            Skript.registerEffect(EffEndermanTeleportTowards.class, (String[])new String[]{"teleport %livingentities% towards %entity%"});
        }
    }
}

