/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.enderman.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enderman - Escape Reason")
@Description(value={"Returns the Escape Reason in an Enderman Escape Event.\nThis Expression requires Paper."})
@Examples(value={"on enderman escape:\n\tbroadcast event-enderman escape reason"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class ExprEndermanEscapeReason
extends SimpleExpression<EndermanEscapeEvent.Reason> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(EndermanEscapeEvent.class)) {
            Skript.error((String)"This expression can only be used in the Enderman Escape Event!");
            return false;
        }
        return true;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    EndermanEscapeEvent.Reason @NotNull [] get(@NotNull Event e) {
        return new EndermanEscapeEvent.Reason[]{((EndermanEscapeEvent)e).getReason()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends EndermanEscapeEvent.Reason> getReturnType() {
        return EndermanEscapeEvent.Reason.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the enderman escape reason";
    }

    static {
        if (Skript.classExists((String)"com.destroystokyo.paper.event.entity.EndermanEscapeEvent")) {
            Skript.registerExpression(ExprEndermanEscapeReason.class, EndermanEscapeEvent.Reason.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] enderman escape reason"});
        }
    }
}

