/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endersignal.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;

@Name(value="Ender Signal - is Going to Drop/Shatter")
@Description(value={"Checks if the provided ender signals should drop an item on death. If true, they will drop an item. If false, they will shatter."})
@Examples(value={"if ender signal {_enderSingle} is going to drop:"})
@Since(value={"1.3"})
public class CondEnderSignalItemDrop
extends PrefixedPropertyCondition<Entity> {
    private boolean shatter;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.shatter = parseResult.hasTag("shatter");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    public boolean check(Entity value) {
        EnderSignal enderSignal;
        return value instanceof EnderSignal && (enderSignal = (EnderSignal)value).getDropItem() ^ this.shatter;
    }

    protected String getPropertyName() {
        return "going to " + (this.shatter ? "shatter" : "drop");
    }

    @Override
    public String getPrefix() {
        return "ender signal";
    }

    static {
        CondEnderSignalItemDrop.register(CondEnderSignalItemDrop.class, "[ender (signal|eye)]", "going to (drop|:shatter)", "entities");
    }
}

