/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endersignal.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Location;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Ender Signal - Set Target Location Without Updating")
@Description(value={"Sets the location the provided ender signals are moving towards without changing the drop chance and the despawn timer."})
@Examples(value={"set the ender signal target location of {_enderSignal} to {_location} without updating"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper"})
public class EffEnderSignalTargetLocation
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Location> locationExpression;

    protected void execute(Event event) {
        Location location = (Location)this.locationExpression.getSingle(event);
        if (location == null) {
            return;
        }
        for (Entity entity : (Entity[])this.entityExpression.getAll(event)) {
            if (!(entity instanceof EnderSignal)) continue;
            EnderSignal enderSignal = (EnderSignal)entity;
            enderSignal.setTargetLocation(location, false);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "set the ender signal target location of " + this.entityExpression.toString(event, debug) + " to " + this.locationExpression.toString(event, debug) + " without updating it";
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = expressions[0];
        this.locationExpression = expressions[1];
        return true;
    }

    static {
        if (Constants.PAPER_HAS_ENDER_SIGNAL_SET_TARGET_LOCATION) {
            Skript.registerEffect(EffEnderSignalTargetLocation.class, (String[])new String[]{"set [the] ender (signal|eye) target location of %entities% to %location% without updating [it]", "set %entities%'[s] ender (signal|eye) target location to %location% without updating [it]"});
        }
    }
}

