/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endersignal.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Ender Signal - Despawn Time/ticks")
@Description(value={"Gets how long the provided ender signals have been alive for.\nCan be set.\nEither as ticks or a timespan.\nWhen greater than 80 ticks (or 4 seconds), it will despawn on the next tick.\n"})
@Examples(value={"send the ender signal despawn time of {_enderSignal}"})
@Since(value={"1.3"})
public class ExprEnderSignalDespawnTime
extends SimplerPropertyExpression<Entity, Object> {
    private boolean usesTicks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.usesTicks = parseResult.hasTag("ticks");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Object convert(Entity from) {
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            int ticks = enderSignal.getDespawnTimer();
            if (this.usesTicks) {
                return ticks;
            }
            return CompatibilityUtils.fromTicks(ticks);
        }
        return null;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (this.usesTicks) {
                return new Class[]{Integer.class};
            }
            return new Class[]{Timespan.class};
        }
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[0];
        }
        return null;
    }

    @Override
    public void set(Entity from, Object to) {
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            if (to instanceof Integer) {
                Integer integer = (Integer)to;
                enderSignal.setDespawnTimer(integer.intValue());
            } else if (to instanceof Timespan) {
                Timespan timespan = (Timespan)to;
                enderSignal.setDespawnTimer((int)CompatibilityUtils.getTicks(timespan));
            }
        }
    }

    protected String getPropertyName() {
        return "ender signal despawn " + (this.usesTicks ? "ticks" : "time");
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    static {
        ExprEnderSignalDespawnTime.register(ExprEnderSignalDespawnTime.class, Object.class, (String)"ender (signal|eye) despawn (time[r]|:ticks)", (String)"entities");
    }
}

