/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endersignal.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Ender Signal - Item")
@Description(value={"Gets the item the provided ender signals will display and drop on death.\n"})
@Examples(value={"set ender signal item of {_signal} to iron sword"})
@Since(value={"1.3"})
public class ExprEnderSignalItem
extends SimplerPropertyExpression<Entity, ItemType> {
    @Nullable
    public ItemType convert(Entity from) {
        ItemType itemType;
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            itemType = new ItemType(enderSignal.getItem());
        } else {
            itemType = null;
        }
        return itemType;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(Entity from, ItemType to) {
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            enderSignal.setItem(to.getRandom());
        }
    }

    protected String getPropertyName() {
        return "ender signal item";
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    static {
        ExprEnderSignalItem.register(ExprEnderSignalItem.class, ItemType.class, (String)"ender (signal|eye) item", (String)"entities");
    }
}

