/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.endersignal.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.Location;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Ender Signal - Target Location")
@Description(value={"Gets the location the provided ender signals are moving towards.\nWhen set, the drop chance resets to a random value and the despawn timer gets set back to 0.\n"})
@Examples(value={"set ender signal target location of {_signal} to {_location}"})
@Since(value={"1.3"})
public class ExprEnderSignalTargetLocation
extends SimplerPropertyExpression<Entity, Location> {
    @Nullable
    public Location convert(Entity from) {
        Location location;
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            location = enderSignal.getTargetLocation();
        } else {
            location = null;
        }
        return location;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(Entity from, Location to) {
        if (from instanceof EnderSignal) {
            EnderSignal enderSignal = (EnderSignal)from;
            enderSignal.setTargetLocation(to);
        }
    }

    protected String getPropertyName() {
        return "ender signal target location";
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    static {
        ExprEnderSignalTargetLocation.register(ExprEnderSignalTargetLocation.class, Location.class, (String)"ender (signal|eye) target location", (String)"entities");
    }
}

