/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Animal - is Interested")
@Description(value={"Checks if the provided foxed or wolves are interested.\nFor Foxes, Paper 1.18.2+ is required."})
@Examples(value={"on damage of wolf:\n\tif victim is interested:\n\t\tcancel event"})
@Since(value={"1.0.0"})
@DocumentationId(value="8796")
public class CondEntityInterested
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isInterested(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "interested";
    }

    static {
        CondEntityInterested.register(CondEntityInterested.class, (String)"interested", (String)"livingentities");
    }
}

