/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Converting")
@Description(value={"Checks if the provided entities being converted.\n(Hoglin, Husk, Piglin, Pig Zombie, Skeleton, Zombie, Zombie Villager)"})
@Examples(value={"on damage of piglin:\n\tif victim is converting:\n\t\tcancel event"})
@Since(value={"1.0.3"})
@DocumentationId(value="9113")
public class CondEntityIsConverting
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isConverting(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "converting";
    }

    static {
        CondEntityIsConverting.register(CondEntityIsConverting.class, (String)"converting", (String)"livingentities");
    }
}

