/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Roaring")
@Description(value={"Checks if an entity is roaring.\nFor ravagers, Paper 1.19.2+ is required."})
@Examples(value={"on damage of ravager:\n\tvictim is roaring\n\tkill victim"})
@Since(value={"1.1.1"})
public class CondEntityIsRoaring
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        return EntityUtils.isRoaring(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "roaring";
    }

    static {
        CondEntityIsRoaring.register(CondEntityIsRoaring.class, (String)"roaring", (String)"livingentities");
    }
}

