/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.ExtendedPropertyType;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;

@Name(value="Entity - Should Burn In Day")
@Description(value={"Returns whether or not the provided entities should burn during the day.\nApplies to zombies, skeletons (all types), and phantoms\n\nIn 1.17.1 this doesn't work with skeleton variants, such as strays, but it does work with base skeletons.\n\nFor skeletons, this does not take into account the entity's natural fire immunity.\n"})
@Examples(value={"if target should burn in daylight:"})
@Since(value={"1.0.3, 1.1.1 (Skeleton,Phantom), 1.3.3 (1.16.5 bug fixes)"})
@RequiredPlugins(value={"Paper"})
@DocumentationId(value="11181")
public class CondEntityShouldBurnInDay
extends PrefixedPropertyCondition<LivingEntity> {
    public boolean check(LivingEntity value) {
        return EntityUtils.shouldBurnDuringTheDay(value);
    }

    protected String getPropertyName() {
        return "burn in the daylight";
    }

    @Override
    public String getPrefix() {
        return "living entity";
    }

    static {
        CondEntityShouldBurnInDay.register(CondEntityShouldBurnInDay.class, ExtendedPropertyType.SHOULD, "[[living[ |-]]entity]", "burn ((during|in) [the] day|(in|under) [the] (sun[light]|daylight))", "livingentities");
    }
}

