/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Pose;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - is Standing")
@Description(value={"Checks if an entity is standing, mainly polar bears, but other entities can be standing."})
@Examples(value={"on damage of polar bear:\n\tif victim is standing:\n\t\tcancel event\n\t\tsend \"you can't, %victim% is standing on business\" to attacker"})
@Since(value={"1.2"})
public class CondEntityStanding
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        if (entity instanceof PolarBear) {
            PolarBear polarBear = (PolarBear)entity;
            return polarBear.isStanding();
        }
        return entity.getPose().equals((Object)Pose.STANDING);
    }

    @NotNull
    protected String getPropertyName() {
        return "standing";
    }

    static {
        CondEntityStanding.register(CondEntityStanding.class, (String)"standing", (String)"livingentities");
    }
}

