/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Make Burn Under the Sun")
@Description(value={"Makes the provided entities burn (or not) when under the sun."})
@Examples(value={"make target burn during the day"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper"})
public class EffEntityBurnInDay
extends Effect {
    private Expression<LivingEntity> entity;
    private boolean shouldBurn;

    protected void execute(Event event) {
        for (LivingEntity livingEntity : (LivingEntity[])this.entity.getAll(event)) {
            EntityUtils.setShouldBurnDuringTheDay(livingEntity, this.shouldBurn);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.entity.toString(event, debug) + (this.shouldBurn ? " " : " not ") + "burn during the day";
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = expressions[0];
        this.shouldBurn = matchedPattern == 0 ^ parseResult.hasTag("not");
        return true;
    }

    static {
        Skript.registerEffect(EffEntityBurnInDay.class, (String[])new String[]{"make %livingentities% [:not] burn ((during|in) [the] day|(in|under) [the] (sun[light]|daylight))", "make %livingentities% [:not] immune to [the] (sun[light]|daylight)"});
    }
}

