/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.paperlib.PaperLib;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.Constants;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;

public class EvtEntityEvents {
    static {
        if (Skript.classExists((String)"org.bukkit.event.entity.EntityEnterLoveModeEvent")) {
            Skript.registerEvent((String)"Entity - on Love Mode Enter", SimpleEvent.class, EntityEnterLoveModeEvent.class, (String[])new String[]{"love [mode] (enter|start)[ed|ing]"}).description(new String[]{"Called when an entity enters love mode.\nThis can be cancelled but the used item will still be consumed."}).examples(new String[]{""}).since("1.0.2");
            CompatibilityUtils.registerEventValue(EntityEnterLoveModeEvent.class, CommandSender.class, EntityEnterLoveModeEvent::getHumanEntity, 0);
        }
        if (Skript.classExists((String)"org.bukkit.event.entity.EntityPoseChangeEvent")) {
            Skript.registerEvent((String)"Entity - on Pose Change", SimpleEvent.class, EntityPoseChangeEvent.class, (String[])new String[]{"[entity] pose change[d]"}).description(new String[]{"Called when an entity changes its pose.\n\nNote: **`past event-pose` is the same as `pose of event-entity`, due to this it's not guaranteed that it will always work correctly.**\n"}).examples(new String[]{""}).since("1.0.2, 1.3 (past event-pose)");
            CompatibilityUtils.registerEventValue(EntityPoseChangeEvent.class, Pose.class, e -> e.getEntity().getPose(), -1);
            CompatibilityUtils.registerEventValue(EntityPoseChangeEvent.class, Pose.class, EntityPoseChangeEvent::getPose, 0);
        }
        if (Skript.classExists((String)"io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent")) {
            Skript.registerEvent((String)"Entity - on Push by Entity Attack", SimpleEvent.class, EntityPushedByEntityAttackEvent.class, (String[])new String[]{"(entity attack push|push by [entity] attack)"}).description(new String[]{"Fired when an entity is pushed by another entity's attack.\nThe acceleration vector can be modified. If this event is cancelled, the entity will not get pushed.\n\nNote: Some entities might trigger this multiple times on the same entity as multiple acceleration calculations are done."}).examples(new String[]{"on entity attack push:"}).requiredPlugins(new String[]{"Paper"}).since("1.0.2");
        }
        if (Constants.PAPER_1_20_6) {
            Skript.registerEvent((String)"Entity - on Knockback", SimpleEvent.class, EntityKnockbackEvent.class, (String[])new String[]{"entity knockback"}).description(new String[]{"Called when an entity receives knockback."}).examples(new String[]{"on entity knockback:"}).requiredPlugins(new String[]{"Paper"}).since("1.3.3");
            CompatibilityUtils.registerEventValue(EntityKnockbackEvent.class, Vector.class, EntityKnockbackEvent::getKnockback, 0);
        }
        if (PaperLib.isPaper()) {
            Skript.registerEvent((String)"Entity - on Knockback by Entity", SimpleEvent.class, EntityKnockbackByEntityEvent.class, (String[])new String[]{"entity knockback by entity"}).description(new String[]{"Fired when an Entity is knocked back by the hit of another Entity.\nThe acceleration vector can be modified. If this event is cancelled, the entity is not knocked back."}).examples(new String[]{"on entity knockback by entity:"}).requiredPlugins(new String[]{"Paper"}).since("1.3.3");
        }
        if (Skript.classExists((String)"org.bukkit.event.entity.EntityShootBowEvent")) {
            Skript.registerEvent((String)"Entity - on Shoot", SimpleEvent.class, EntityShootBowEvent.class, (String[])new String[]{"entity shoot[ing]"}).description(new String[]{"Called when a LivingEntity shoots a bow firing an arrow."}).examples(new String[]{""}).since("1.1.1");
            CompatibilityUtils.registerEventValue(EntityShootBowEvent.class, Projectile.class, e -> {
                Projectile projectile;
                Entity patt0$temp = e.getProjectile();
                return patt0$temp instanceof Projectile ? (projectile = (Projectile)patt0$temp) : null;
            }, 0);
        }
        if (Skript.classExists((String)"org.bukkit.event.entity.EntityPlaceEvent")) {
            Skript.registerEvent((String)"Entity - on Place", SimpleEvent.class, EntityPlaceEvent.class, (String[])new String[]{"entity [getting] place[d]"}).description(new String[]{"Triggered when an entity is created in the world by a player \"placing\" an item on a block.\nNote that this event is currently only fired for four specific placements: armor stands, boats, minecarts, and end crystals."}).examples(new String[]{""}).since("1.1.1");
            CompatibilityUtils.registerEventValue(EntityPlaceEvent.class, Block.class, EntityPlaceEvent::getBlock, 0);
            CompatibilityUtils.registerEventValue(EntityPlaceEvent.class, Player.class, EntityPlaceEvent::getPlayer, 0);
            CompatibilityUtils.registerEventValue(EntityPlaceEvent.class, BlockFace.class, EntityPlaceEvent::getBlockFace, 0);
            if (Constants.MINECRAFT_1_19_2) {
                CompatibilityUtils.registerEventValue(EntityPlaceEvent.class, EquipmentSlot.class, EntityPlaceEvent::getHand, 0);
            }
        }
        if (Skript.classExists((String)"io.papermc.paper.event.entity.EntityInsideBlockEvent")) {
            Skript.registerEvent((String)"Entity - on Collide With Block", SimpleEvent.class, EntityInsideBlockEvent.class, (String[])new String[]{"entity ((collide with|in[side]) [a] block)"}).description(new String[]{"Called when an entity enters the hitbox of a block. Only called for blocks that react when an entity is inside. If cancelled, any action that would have resulted from that entity being in the block will not happen (such as extinguishing an entity in a cauldron).\nBlocks this is currently called for:\n\nBig dripleaf\nBubble column\nButtons\nCactus\nCampfire\nCauldron\nCrops\nEnder Portal\nFires\nFrogspawn\nHoney\nHopper\nDetector rails\nNether portals\nPowdered snow\nPressure plates\nSweet berry bush\nTripwire\nWaterlily\nWeb\nWither rose"}).examples(new String[]{""}).since("1.1.1").requiredPlugins(new String[]{"Paper"}).documentationID("11161");
        }
        if (Constants.PAPER_1_18_2) {
            Skript.registerEvent((String)"Tameable - on Death Message", SimpleEvent.class, TameableDeathMessageEvent.class, (String[])new String[]{"(tameable|pet) death message"}).description(new String[]{"Called when a Tameable dies and sends a death message."}).examples(new String[]{""}).requiredPlugins(new String[]{"Paper 1.18.2+"}).since("1.3.8");
            CompatibilityUtils.registerEventValue(TameableDeathMessageEvent.class, Entity.class, TameableDeathMessageEvent::getEntity, 0);
            CompatibilityUtils.registerEventValue(TameableDeathMessageEvent.class, String.class, tameableDeathMessageEvent -> LegacyComponentSerializer.legacySection().serialize(tameableDeathMessageEvent.deathMessage()), 0);
        }
    }
}

