/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.entity.EntityDyeEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.DyeColor;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Dye Event - Dye Color")
@Description(value={"Returns the applied color in the Dye event.\n This expression can be set to another dye color."})
@Examples(value={"on dye:\n\tbroadcast the entity dye color"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class ExprDyeColor
extends SimpleExpression<SkriptColor> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(EntityDyeEvent.class)) {
            Skript.error((String)"This expression can only be used in the Dye Event!");
            return false;
        }
        return true;
    }

    protected SkriptColor @NotNull [] get(@NotNull Event e) {
        return new SkriptColor[]{SkriptColor.fromDyeColor((DyeColor)((EntityDyeEvent)e).getColor())};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = SkriptColor[].class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof SkriptColor) {
            SkriptColor color = (SkriptColor)object;
            ((EntityDyeEvent)e).setColor(color.asDyeColor());
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends SkriptColor> getReturnType() {
        return SkriptColor.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the entity dye color";
    }

    static {
        Skript.registerExpression(ExprDyeColor.class, SkriptColor.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the |event-]entity dye color"});
    }
}

