/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.SimplerPluralPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

@Name(value="Entity - Collidable Exemptions")
@Description(value={"Gets the list of entities (or their UUIDs) which are exempt from the provided entities' collidable rule and whose collision with this entity will behave the opposite of it.\nCan be set, added to, removed from, and deleted.\n\nFor example if collidable is true and an entity is in the exemptions then it will not collide with it.\nSimilarly if collidable is false and an entity is in this set then it will still collide with it.\n\nNote: **these exemptions are not (currently) persistent.**\n\nNote: **the client may predict the collision between itself and another entity, resulting in those exemptions not being accurate for player collisions.**\n **This expression should therefore only be used to exempt non-player entities.**\n **To exempt collisions for a player, use the Team Collision Rule Option in combination with a Scoreboard and a Team.**\n"})
@Examples(value={"send collidable exemptions of {_entity}"})
@Since(value={"1.3"})
public class ExprEntityCollidableExemptions
extends SimplerPluralPropertyExpression<LivingEntity, Object> {
    private boolean uuid;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.uuid = parseResult.hasTag("uuid");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public Object[] get(LivingEntity livingEntity) {
        Stream stream = livingEntity.getCollidableExemptions().stream();
        if (this.uuid) {
            return stream.toArray();
        }
        return stream.map(Bukkit::getEntity).toArray(Entity[]::new);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowAdd() {
        return true;
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Object[] to) {
        this.delete(from);
        this.add(from, to);
    }

    @Override
    public void add(LivingEntity from, Object[] to) {
        from.getCollidableExemptions().addAll(EntityUtils.getArrayAsUUIDList(to));
    }

    @Override
    public void remove(LivingEntity from, Object[] to) {
        EntityUtils.getArrayAsUUIDList(to).forEach(from.getCollidableExemptions()::remove);
    }

    @Override
    public void delete(LivingEntity from) {
        this.remove(from, from.getCollidableExemptions().toArray());
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    protected String getPropertyName() {
        return "collidable exemptions " + (this.uuid ? "uuid" : "");
    }

    static {
        ExprEntityCollidableExemptions.register(ExprEntityCollidableExemptions.class, Object.class, (String)"collidable exemptions [uuid:uuid[s]]", (String)"livingentities");
    }
}

