/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Client Sided Custom Name Visibility (Property)")
@Description(value={"Gets whether or not the entity's custom name is displayed client side.\nThis value has no effect on players, they will always display their name."})
@Examples(value={"broadcast custom name visibility of target"})
@Since(value={"1.3"})
public class ExprEntityCustomNameVisibility
extends SimpleBooleanPropertyExpression<Entity> {
    @Override
    public boolean setNegated(int matchedPattern, SkriptParser.ParseResult parseResult) {
        return parseResult.hasTag("in");
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(Entity from, Boolean bool) {
        from.setCustomNameVisible(bool.booleanValue());
    }

    @Nullable
    public Boolean convert(Entity from) {
        return from.isCustomNameVisible() ^ this.isNegated();
    }

    protected String getPropertyName() {
        return "custom name " + (this.isNegated() ? "in" : "") + "visibility";
    }

    static {
        ExprEntityCustomNameVisibility.register(ExprEntityCustomNameVisibility.class, Boolean.class, (String)"[client[[-| ]side[d]]] custom[ |-]name [:in]visibility", (String)"entities");
    }
}

