/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - is Aggressive (Property)")
@Description(value={"Returns the Aggressive Property of an entity.\nCan be set.\n\nSome mobs will raise their arm(s) when aggressive:\nDrowned, Piglin, Skeleton, Zombie, ZombieVillager, Illusioner, Vindicator, Panda, Pillager, PiglinBrute\n\nNote: This doesn't always return the actual aggressive state as when set, Pandas are always aggressive if their combined Panda Gene is AGGRESSIVE."})
@Examples(value={"broadcast is aggressive state of target"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper 1.20.2+"})
public class ExprEntityIsAggressive
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Mob mob;
        return from instanceof Mob && (mob = (Mob)from).isAggressive();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Mob) {
            Mob mob = (Mob)from;
            mob.setAggressive(to.booleanValue());
        }
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "is aggressive";
    }

    static {
        if (Constants.MINECRAFT_1_20_2) {
            ExprEntityIsAggressive.register(ExprEntityIsAggressive.class, Boolean.class, (String)"[is] aggressive", (String)"livingentities");
        }
    }
}

