/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - is Angry (Property)")
@Description(value={"Returns the Angry Property of an entity. (Warden, PigZombie, Wolf, Enderman)\nCan be set for all except wardens.\n\nTo use this for endermen `Paper 1.18.2+` is required.\n"})
@Examples(value={"broadcast is angry state of target"})
@Since(value={"1.0.2"})
@DocumentationId(value="9070")
public class ExprEntityIsAngry
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        return EntityUtils.isAngry(from);
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        EntityUtils.setIsAngry(from, to);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "is angry";
    }

    static {
        ExprEntityIsAngry.register(ExprEntityIsAngry.class, Boolean.class, (String)"[is] angry", (String)"livingentities");
    }
}

