/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - is Screaming (Property)")
@Description(value={"Returns the Screaming Property of an entity.\nThis is for Endermen (Requires Paper and 1.18.2+) and Goats."})
@Examples(value={"broadcast screaming state of target"})
@Since(value={"1.0.2"})
public class ExprEntityIsScreaming
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        return EntityUtils.isScreaming(from);
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        EntityUtils.setIsScreaming(from, to);
    }

    @Override
    public void reset(LivingEntity from) {
        EntityUtils.setIsScreaming(from, false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "is screaming";
    }

    static {
        ExprEntityIsScreaming.register(ExprEntityIsScreaming.class, Boolean.class, (String)"[is] screaming", (String)"livingentities");
    }
}

