/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot - Force")
@Description(value={"The force the arrow was launched with in the Entity Shoot Event.\nThis number ranges from 0 to 1."})
@Examples(value={"on entity shoot:\n\tbroadcast the bow force"})
@Since(value={"1.1.1"})
public class ExprEntityShootForce
extends SimpleExpression<Number> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)"This expression can only be used in the Entity Shoot event!");
            return false;
        }
        return true;
    }

    protected Number @NotNull [] get(@NotNull Event e) {
        return new Number[]{Float.valueOf(((EntityShootBowEvent)e).getForce())};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the shot force";
    }

    static {
        Skript.registerExpression(ExprEntityShootForce.class, Number.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the |event-](bow [shoot]|arrow [launch|shot]|sho[o]t) force"});
    }
}

