/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot - Bow/Item")
@Description(value={"The bow used to fire the arrow and the consumed arrow in the Entity Shoot Event.\nBoth can be null."})
@Examples(value={"on entity shoot:\n\tbroadcast the used bow"})
@Since(value={"1.1.1"})
public class ExprEntityShootItem
extends SimpleExpression<ItemStack> {
    boolean bow;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)"This expression can only be used in the Entity Shoot event!");
            return false;
        }
        this.bow = matchedPattern == 0;
        return true;
    }

    protected ItemStack @NotNull [] get(@NotNull Event e) {
        EntityShootBowEvent shootBowEvent = (EntityShootBowEvent)e;
        return new ItemStack[]{this.bow ? shootBowEvent.getBow() : shootBowEvent.getConsumable()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return this.bow ? "the used bow" : "the shot item";
    }

    static {
        Skript.registerExpression(ExprEntityShootItem.class, ItemStack.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the |event-]used bow", "[the |event-](consumed|shot) item"});
    }
}

