/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - Snapshot")
@Description(value={"Creates an EntitySnapshot representing the current state of this entity."})
@Examples(value={"broadcast entity snapshot of target"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.20.2"})
public class ExprEntitySnapshot
extends SimplePropertyExpression<Entity, EntitySnapshot> {
    @NotNull
    public Class<? extends EntitySnapshot> getReturnType() {
        return EntitySnapshot.class;
    }

    public EntitySnapshot convert(Entity e) {
        return e.createSnapshot();
    }

    @NotNull
    protected String getPropertyName() {
        return "entity snapshot";
    }

    static {
        if (Constants.HAS_ENTITY_SNAPSHOT) {
            ExprEntitySnapshot.register(ExprEntitySnapshot.class, EntitySnapshot.class, (String)"entity snapshot", (String)"entities");
        }
    }
}

