/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Variant")
@Description(value={"Returns the Variant of an Entity.\nCan be set.\nThis does not use strings.\n\nCurrently supports:\n- Cow (1.21.5+)\n- Chicken (1.21.5+)\n- Pig (1.21.5+)\n- Salmon (1.21.2+)\n- Wolf (1.20.5+)\n- Frog (1.19+)\n- Axolotl (1.17+)\n- Mushroom Cow\n- Parrot\n- Llama\n- Fox\n- Cat\n- Rabbit\n- Panda\n- Tropical Fish\n"})
@Examples(value={"broadcast variant of event-entity", "set variant of target to \"red\""})
@Since(value={"1.0.0, 1.0.2 (Set), 1.0.3 (String + More), 1.3.6 (Cow, Chicken, Pig + Safety Checks)"})
public class ExprEntityVariant
extends SimplerPropertyExpression<LivingEntity, Object> {
    @Nullable
    public Object convert(LivingEntity from) {
        return EntityUtils.getVariant(from);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Object to) {
        EntityUtils.setVariant(from, to);
    }

    protected String getPropertyName() {
        return "entity variant";
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    static {
        ExprEntityVariant.register(ExprEntityVariant.class, Object.class, (String)"[entity] variant", (String)"livingentities");
    }
}

