/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import it.jakegblp.lusk.utils.Constants;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Tameable Death Message Event -  Death Message")
@Description(value={"Returns the applied color in the Dye event.\n This expression can be set to another dye color."})
@Examples(value={"on dye:\n\tbroadcast the entity dye color"})
@Since(value={"1.3.8"})
@RequiredPlugins(value={"Paper 1.18.2+"})
public class ExprTameableDeathMessage
extends SimpleExpression<String> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(TameableDeathMessageEvent.class)) {
            Skript.error((String)"This expression can only be used in the Tameable Death Message Event!");
            return false;
        }
        return true;
    }

    protected String @NotNull [] get(@NotNull Event e) {
        return new String[]{LegacyComponentSerializer.legacySection().serialize(((TameableDeathMessageEvent)e).deathMessage())};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = String[].class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof String) {
            String string = (String)object;
            ((TameableDeathMessageEvent)e).deathMessage((Component)LegacyComponentSerializer.legacySection().deserialize(string));
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the tameable death message";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            Skript.registerExpression(ExprTameableDeathMessage.class, String.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the |event-]tameable death message"});
        }
    }
}

