/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.listeners.HealListener;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - on Heal Section")
@Description(value={"Runs the code inside of it when the provided entity gets healed.\nLocal Variables that are:\n- defined BEFORE this section CAN be used inside of it.\n- defined AFTER this section CANNOT be used inside of it.\n- defined INSIDE this section CANNOT be used outside of it.\n"})
@Examples(value={"command /a:\n  trigger:\n    spawn pig at player:\n      set display name of entity to \"&dPig &7- &c%health of entity%&8/&c%max health of entity%\"\n      on heal of entity:\n        push entity upwards\n        broadcast \"%entity% has been healed, yay\"\n"})
@Since(value={"1.1"})
public class SecEvtHeal
extends Section {
    private Expression<Entity> entity;
    @Nullable
    private Trigger trigger;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> list) {
        this.entity = expressions[0];
        this.trigger = this.loadCode(sectionNode, "heal", new Class[]{EntityRegainHealthEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event event) {
        Object vars = Variables.copyLocalVariables((Event)event);
        Consumer<EntityRegainHealthEvent> consumer = this.trigger == null ? null : healEvent -> {
            Variables.setLocalVariables((Event)healEvent, (Object)vars);
            TriggerItem.walk((TriggerItem)this.trigger, (Event)healEvent);
            Variables.removeLocals((Event)healEvent);
        };
        HealListener.log(consumer, (Entity)this.entity.getSingle(event));
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "when " + this.entity.toString(event, b) + " gets healed";
    }

    static {
        Skript.registerSection(SecEvtHeal.class, (String[])new String[]{"[execute|run] on heal of %~entity%", "[execute|run] when %~entity% get[s] healed"});
    }
}

