/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Fox - is Leaping")
@Description(value={"Checks if a fox is leaping."})
@Examples(value={"on damage of fox:\n\tif victim is leaping:\n\t\tcancel event"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper 1.18.2"})
public class CondFoxLeaping
extends PrefixedPropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Fox fox;
        return entity instanceof Fox && (fox = (Fox)entity).isLeaping();
    }

    @NotNull
    protected String getPropertyName() {
        return "leaping";
    }

    @Override
    public String getPrefix() {
        return "foxes";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            CondFoxLeaping.register(CondFoxLeaping.class, "[fox[es]]", "leaping", "livingentities");
        }
    }
}

