/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Fox - Trusts Players")
@Description(value={"Checks if the provided foxes trust the provided offline players."})
@Examples(value={"if {_fox} trusts player:"})
@Since(value={"1.3"})
public class CondFoxTrusts
extends Condition {
    private Expression<LivingEntity> livingEntityExpression;
    private Expression<OfflinePlayer> offlinePlayerExpression;

    public boolean check(Event event) {
        return CompatibilityUtils.test(this.livingEntityExpression, event, livingEntity -> {
            if (livingEntity instanceof Fox) {
                Fox fox = (Fox)livingEntity;
                return CompatibilityUtils.test(this.offlinePlayerExpression, event, offlinePlayer -> {
                    if (fox.getFirstTrustedPlayer() == null) {
                        return false;
                    }
                    UUID uuid = offlinePlayer.getUniqueId();
                    if (fox.getFirstTrustedPlayer().getUniqueId() == uuid) {
                        return true;
                    }
                    return fox.getSecondTrustedPlayer() != null && fox.getSecondTrustedPlayer().getUniqueId() == uuid;
                });
            }
            return false;
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "foxes " + this.livingEntityExpression.toString(event, debug) + (this.isNegated() ? " does not" : "") + " trust " + this.offlinePlayerExpression.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.livingEntityExpression = expressions[0];
        this.offlinePlayerExpression = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondFoxTrusts.class, (String[])new String[]{"[fox[es]] %livingentities% trust[s] %offlineplayers%", "[fox[es]] %livingentities% do[es](n't| not) trust %offlineplayers%"});
    }
}

