/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;

@Name(value="Fox - is Leaping (Property)")
@Description(value={"Gets whether the provided foxed are leaping, can be set and reset."})
@Examples(value={"broadcast the fox is leaping property of target"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper 1.18.2+"})
public class ExprFoxLeaping
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    public Boolean convert(LivingEntity from) {
        Fox fox;
        return from instanceof Fox && (fox = (Fox)from).isLeaping();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            fox.setLeaping(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    protected String getPropertyName() {
        return "fox is leaping";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprFoxLeaping.register(ExprFoxLeaping.class, Boolean.class, "fox", "[is] leaping", "livingentities");
        }
    }
}

