/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;

@Name(value="Fox - is Sleeping (Property)")
@Description(value={"Various fox properties.\nEverything in this expression can be used with `Paper`.\nWith `Spigot` you can only:\n - `Get` and `Set` the Crouching State and Sleeping State\n - `Get` the Faceplanted State\n"})
@Examples(value={"broadcast fox is sleeping property of target"})
@Since(value={"1.2"})
@DocumentationId(value="9076")
public class ExprFoxSleeping
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            fox.setSleeping(to.booleanValue());
        }
    }

    public Boolean convert(LivingEntity from) {
        return from.isSleeping();
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    protected String getPropertyName() {
        return "fox is sleeping";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprFoxSleeping.register(ExprFoxSleeping.class, Boolean.class, "fox", "[is] sleeping", "livingentities");
        }
    }
}

