/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fox - Trusted Players")
@Description(value={"Returns the first, second, or both trusted players of 1 or more foxes.\n\n*NOTES*:\n- The first and second trusted players can both be set to a single `offline player`, the trusted players can be set to 2 offline players (or 1, which only sets the first one).\n- The second trusted player must be set after the first one, which also means you can't clear the first one if the second one is set, both actions will fail silently.\n- If you wish to set/clear both, do so by using the second pattern: `clear trusted players of {_fox}`\n"})
@Examples(value={"broadcast first trusted player of {_fox}", "set trusted players of {_fox} to {_notch} and {_steve}"})
@Since(value={"1.2"})
public class ExprFoxTrustedPlayers
extends PropertyExpression<LivingEntity, OfflinePlayer> {
    int state;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.state = parseResult.hasTag("both") ? 1 : (parseResult.hasTag("second") ? 0 : -1);
        this.setExpr(expressions[0]);
        return true;
    }

    protected OfflinePlayer @NotNull [] get(@NotNull Event event, LivingEntity @NotNull [] source) {
        ArrayList<OfflinePlayer> trusted = new ArrayList<OfflinePlayer>();
        for (LivingEntity livingEntity : source) {
            OfflinePlayer player;
            AnimalTamer animalTamer;
            if (!(livingEntity instanceof Fox)) continue;
            Fox fox = (Fox)livingEntity;
            if (this.state != 0 && (animalTamer = fox.getFirstTrustedPlayer()) instanceof OfflinePlayer) {
                player = (OfflinePlayer)animalTamer;
                trusted.add(player);
            }
            if (this.state == -1 || !((animalTamer = fox.getSecondTrustedPlayer()) instanceof OfflinePlayer)) continue;
            player = (OfflinePlayer)animalTamer;
            trusted.add(player);
        }
        return trusted.toArray(new OfflinePlayer[0]);
    }

    @Override
    public boolean isSingle() {
        return this.state == 1 || super.isSingle();
    }

    @NotNull
    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    @Nullable
    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{this.state == 1 ? OfflinePlayer[].class : OfflinePlayer.class};
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        block13: {
            OfflinePlayer offlinePlayer;
            Fox[] foxes;
            block15: {
                block14: {
                    block12: {
                        foxes = (Fox[])this.getExpr().stream(event).filter(Fox.class::isInstance).map(Fox.class::cast).toArray(Fox[]::new);
                        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) break block12;
                        if (this.state == -1) {
                            for (Fox fox : foxes) {
                                if (fox.getSecondTrustedPlayer() != null) continue;
                                fox.setFirstTrustedPlayer(null);
                            }
                        } else if (this.state == 0) {
                            for (Fox fox : foxes) {
                                fox.setSecondTrustedPlayer(null);
                            }
                        } else {
                            for (Fox fox : foxes) {
                                fox.setSecondTrustedPlayer(null);
                                fox.setFirstTrustedPlayer(null);
                            }
                        }
                        break block13;
                    }
                    if (mode != Changer.ChangeMode.SET) break block13;
                    if (delta == null || delta[0] == null) {
                        return;
                    }
                    if (this.state != 1 || !(delta instanceof OfflinePlayer[])) break block14;
                    OfflinePlayer[] offlinePlayers = (OfflinePlayer[])delta;
                    for (Fox fox : foxes) {
                        if (offlinePlayers[0] != null) {
                            fox.setFirstTrustedPlayer((AnimalTamer)offlinePlayers[0]);
                        }
                        if (offlinePlayers[1] == null) continue;
                        fox.setFirstTrustedPlayer((AnimalTamer)offlinePlayers[1]);
                    }
                    break block13;
                }
                Fox[] foxArray = delta[0];
                if (!(foxArray instanceof OfflinePlayer)) break block13;
                offlinePlayer = (OfflinePlayer)foxArray;
                if (this.state != -1) break block15;
                for (Fox fox : foxes) {
                    fox.setFirstTrustedPlayer((AnimalTamer)offlinePlayer);
                }
                break block13;
            }
            if (this.state != 0) break block13;
            for (Fox fox : foxes) {
                if (fox.getFirstTrustedPlayer() == null) continue;
                fox.setSecondTrustedPlayer((AnimalTamer)offlinePlayer);
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder builder = new StringBuilder();
        if (this.state == 1) {
            builder.append("trusted players");
        } else {
            builder.append(this.state == -1 ? "first" : "second").append(" player");
        }
        return builder.append(" of ").append(this.getExpr().toString(event, debug)).toString();
    }

    static {
        ExprFoxTrustedPlayers.register(ExprFoxTrustedPlayers.class, OfflinePlayer.class, "([first|:second] trusted player|both:trusted players)", "livingentities");
    }
}

