/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.goat.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Goat - has Left/Right Horn (Property)")
@Description(value={"Returns whether or not a goat has either horn.\nCan be set and reset."})
@Examples(value={"broadcast goat has left horn state of target"})
@Since(value={"1.0.3"})
public class ExprGoatHornsState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    private boolean left;

    @Override
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.left = parseResult.hasTag("left");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Boolean convert(LivingEntity from) {
        boolean bl;
        if (from instanceof Goat) {
            Goat goat = (Goat)from;
            if (this.left ? goat.hasLeftHorn() : goat.hasRightHorn()) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }

    protected String getPropertyName() {
        return "goat has " + (this.left ? "left" : "right") + " horn";
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Goat) {
            Goat goat = (Goat)from;
            if (this.left) {
                goat.setLeftHorn(to.booleanValue());
            } else {
                goat.setRightHorn(to.booleanValue());
            }
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    static {
        ExprGoatHornsState.register(ExprGoatHornsState.class, Boolean.class, "goat", "[has] (:left|right) horn", "livingentities");
    }
}

