/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.horse.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Horse - Jump Strength")
@Description(value={"Returns the jump strength of an horse.\nCan be set."})
@Examples(value={"broadcast jumping strength of target"})
@Since(value={"1.0.3"})
public class ExprHorseJumpStrength
extends SimpleExpression<Double> {
    private Expression<Entity> entityExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        return true;
    }

    protected Double @NotNull [] get(@NotNull Event e) {
        Entity entity = (Entity)this.entityExpression.getSingle(e);
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return new Double[]{horse.getJumpStrength()};
        }
        return new Double[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Double.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Double) {
            Double aDouble = (Double)object;
            object = this.entityExpression.getSingle(e);
            if (object instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)object;
                horse.setJumpStrength(aDouble.doubleValue());
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the horse jumping strength of " + (e == null ? "" : this.entityExpression.toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprHorseJumpStrength.class, Double.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] horse jump[ing] (strength|force) of %entity%", "%entity%'[s] horse jump[ing] (strength|force)"});
    }
}

