/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.irongolem.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.ExtendedPropertyType;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Iron Golem - Created By a Player")
@Description(value={"Checks if an iron golem was created by a player."})
@Examples(value={"if {_golem} was created by a player:"})
@Since(value={"1.0.3"})
public class CondIronGolemCreatedByPlayer
extends PrefixedPropertyCondition<LivingEntity> {
    public boolean check(LivingEntity value) {
        IronGolem ironGolem;
        return value instanceof IronGolem && (ironGolem = (IronGolem)value).isPlayerCreated();
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "iron golems";
    }

    protected String getPropertyName() {
        return "created by a player";
    }

    static {
        CondIronGolemCreatedByPlayer.register(CondIronGolemCreatedByPlayer.class, ExtendedPropertyType.WAS, "iron[ |-]golem[s]", "(created|built) by ([a] player|players)", "livingentities");
    }
}

