/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.irongolem.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Iron Golem - was Created By a Player (Property)")
@Description(value={"Returns whether or not an iron golem was created by a player.\nCan be set and reset."})
@Examples(value={"broadcast iron golem created by a player property of {_target}"})
@Since(value={"1.0.3"})
public class ExprIronGolemCreatedByPlayerState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        IronGolem ironGolem;
        return from instanceof IronGolem && (ironGolem = (IronGolem)from).isPlayerCreated();
    }

    protected String getPropertyName() {
        return "iron golem was created by a player state";
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof IronGolem) {
            IronGolem ironGolem = (IronGolem)from;
            ironGolem.setPlayerCreated(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    static {
        ExprIronGolemCreatedByPlayerState.register(ExprIronGolemCreatedByPlayerState.class, Boolean.class, "iron golem", "[was] created by ([a] player|players)", "livingentities");
    }
}

