/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

@Name(value="Item Frame - is Fixed")
@Description(value={"Returns whether the item frame is \"fixed\" or not.\nWhen true it's not possible to destroy/move the frame (e. g. by damage, interaction, pistons, or missing supporting blocks), rotate the item or place/remove items."})
@Examples(value={"if item frame {_itemFrame} is fixed:"})
@Since(value={"1.3"})
public class CondItemFrameFixed
extends PrefixedPropertyCondition<Entity> {
    public boolean check(Entity value) {
        ItemFrame itemFrame;
        return value instanceof ItemFrame && (itemFrame = (ItemFrame)value).isFixed();
    }

    protected String getPropertyName() {
        return "fixed";
    }

    @Override
    public String getPrefix() {
        return "item frame";
    }

    static {
        CondItemFrameFixed.register(CondItemFrameFixed.class, "item[ |-]frame", "fixed", "entities");
    }
}

