/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - set Item Silently")
@Description(value={"Sets the item of the provided item frames silently."})
@Examples(value={"silently set itemframe item of {_frame} to iron ingot"})
@Since(value={"1.3"})
public class EffItemFrameSetItemSilently
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<ItemType> itemTypeExpression;

    protected void execute(Event event) {
        ItemType itemType = (ItemType)this.itemTypeExpression.getSingle(event);
        if (itemType == null) {
            return;
        }
        ItemStack itemStack = itemType.getRandom();
        for (Entity entity : (Entity[])this.entityExpression.getAll(event)) {
            if (!(entity instanceof ItemFrame)) continue;
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.setItem(itemStack, false);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "silently set item frame item of " + this.entityExpression.toString(event, debug) + " to " + this.itemTypeExpression.toString(event, debug);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = expressions[0];
        this.itemTypeExpression = expressions[1];
        return true;
    }

    static {
        Skript.registerEffect(EffItemFrameSetItemSilently.class, (String[])new String[]{"silently set [the] item[ |-]frame item of %entities% to %itemtype%", "silently set %entities%'[s] item[ |-]frame item to %itemtype%"});
    }
}

