/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.LuskMath;
import it.jakegblp.lusk.utils.NumberUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - Item Drop Chance")
@Description(value={"The chance of the item being dropped upon this item frame's destruction.\nCan be set, removed from, added to, reset (1) and deleted (0).\n\nThe final value is always clamped between 0 and 1.\n\n1 = always drops; 0 = never drops."})
@Examples(value={"set item frame drop chance of {_itemFrame} to 1 # always drops"})
@Since(value={"1.3"})
public class ExprItemFrameDropChance
extends SimplerPropertyExpression<Entity, Number> {
    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public boolean allowAdd() {
        return true;
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Entity from, Number to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            itemFrame.setItemDropChance(LuskMath.fit(0.0f, to.floatValue(), 1.0f));
        }
    }

    @Override
    public void add(Entity from, Number to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            this.set(from, Float.valueOf(itemFrame.getItemDropChance() + to.floatValue()));
        }
    }

    @Override
    public void remove(Entity from, Number to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            this.set(from, Float.valueOf(itemFrame.getItemDropChance() - to.floatValue()));
        }
    }

    @Override
    public void delete(Entity from) {
        this.set(from, 0);
    }

    @Override
    public void reset(Entity from) {
        this.set(from, 1);
    }

    @Nullable
    public Number convert(Entity from) {
        Double d;
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            d = NumberUtils.roundFloatPrecision(itemFrame.getItemDropChance());
        } else {
            d = null;
        }
        return d;
    }

    protected String getPropertyName() {
        return "item frame item drop chance";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprItemFrameDropChance.register(ExprItemFrameDropChance.class, Number.class, (String)"item[ |-]frame [item] drop chance", (String)"entities");
    }
}

